<?php

/*
 * Plugin Name: DIGITS: Social Login Addon
 * Description: Provide social login functionality with all major providers alongside Digits.
 * Version: 1.1
 * Plugin URI: https://digits.unitedover.com/addons
 * Author URI: https://www.unitedover.com/
 * Author: UnitedOver
 * Text Domain: digsociallogin
 * Requires PHP: 5.5
 * Domain Path: /languages
 */

if (!defined('ABSPATH')) {
    exit;
}


require dirname(__FILE__) . '/handler.php';



function digits_addon_digsociallogin()
{
    return 'digsociallogin';
}


function dig_show_sociallogin($active_tab)
{
    ?>
    <div data-tab="digsociallogintab"
         class="dig_admin_in_pt digsociallogintab digtabview <?php echo $active_tab == digits_addon_digsociallogin() ? 'digcurrentactive' : '" style="display:none;'; ?>">
        <?php digad_show_socialogin_settings(); ?>
    </div>

    <?php

}

add_action('digits_settings_page', 'dig_show_sociallogin');

function digsociallogin_addon($list)
{
    $list[] = 'digsociallogin';
    return $list;
}

add_filter('digits_addon', 'digsociallogin_addon');

function digsociallogin_addon_tab($tabs)
{
    $tabs['digsociallogin'] = array('label' => esc_attr__('Social Logins', 'digits'));
    return $tabs;
}

add_filter('digits_admin_addon_tab', 'digsociallogin_addon_tab');

function digsociallogin_lang_load() {
    load_plugin_textdomain( 'digsociallogin', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' ); 
}
add_action( 'plugins_loaded', 'digsociallogin_lang_load' );